*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Terbufos oxon Sulfoxide                              *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";

libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data TerbufosOxonSulfoxide;
     set epa.toxonsulfoxide;
run;
proc sort data=TerbufosOxonSulfoxide;
     by id;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfoxide - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=TerbufosOxonSulfoxide);
ods rtf close;


*===> Human vs. Rat;

title "Human vs. Rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfoxide  method=firo tech=nrridg lis=3 maxiter=20000 gconv=0;
      PARMS ha=0.9796
			hb=0.9658
			ra=0.7057
			rb=0.9389	
			gha=0.1362	ghab=.1771		ghb=.2429
			gra=.5355	grab=0.8035	grb=.1233
			S2E=0.9765;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-4 + H_I__M + rrb*Rat*1e-4 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-4);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab, ghb,
														 0,    	  0,   gra*1e-1,
														 0,       0,   grab*1e-1, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  Predict PRED out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfoxide human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=TerbufosOxonSulfoxide, model=3)
ods rtf close;
%Calculate_Ki(chemical=TerbufosOxonSulfoxide, Hadj=1e-4, Radj=1e-4);



*===> Adult vs. Infant;


title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfoxide(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.9202	adB=0.8820
			ia=1.2029 iB=1.2868
			gha=1.1051 	ghab=1.4162	ghb=1.9292
			S2E=0.1030;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_AI;
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	   predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfoxide Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=TerbufosOxonSulfoxide, model=2)
ods rtf close;



*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfoxide(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000 method=firo;
      PARMS ma=1.1438 mb= 1.1466
			fa=.8620 fB=0.8346
			gha=.1011 	ghab=0.1349	ghb=0.1912
			S2E=.1024;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
           PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-4 + H_I__M*male + rfb*female*1e-4 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfoxide Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=TerbufosOxonSulfoxide, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfoxide(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.9228	cB=.9118
			ora=1.1255 orB=1.1015
			gha=1.2792	ghab=0.1690	ghb=0.2339
			S2E=.1020;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-4 + H_I__M*caucasian + rorb*otherrace*1e-4 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfoxide Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=TerbufosOxonSulfoxide, model=2)
ods rtf close;
